;;; 
;;; Virtual Disk Drive Project	- Dec 18, 2001 - EJR (in Austin)
;;;
;;; Memory definitions
;;;

;;; -------------------------------------------------------------
;;; COMMON - the given memory locations work in either bank
;;; -------------------------------------------------------------

#define ARG0		0x20	; arguments to functions - up to 3 at once
#define	ARG1		0x21
#define ARG2		0x22

#define WORK0		0x23	; working memory for routines - up to 4 at once
#define WORK1		0x24
#define WORK2		0x25
#define WORK3		0x26

;;; Load States
;;;    Load states are carried in the LOAD_STATE register
;;;    and are tracked with the 8 bits of it.  Note that
;;;    load state 0 is when no bits are set in LOAD_STATE.
;;;    These defines are meant to be the target of a bit
;;;    set or test operation.
	
#define	LOAD_STATE_1	LOAD_STATE,0
#define	LOAD_STATE_2	LOAD_STATE,1
#define	LOAD_STATE_3	LOAD_STATE,2
#define	LOAD_STATE_4	LOAD_STATE,3
#define	LOAD_STATE_5	LOAD_STATE,4
#define	LOAD_STATE_6	LOAD_STATE,5
#define	LOAD_STATE_7	LOAD_STATE,6
#define	LOAD_STATE_8	LOAD_STATE,7

;;; Load State Operations

#define LOAD_STATE_NEXT	rlf	LOAD_STATE
#define LOAD_STATE_0	clrf	LOAD_STATE

#define LOAD_STATE	0x27	; current state of serial read
#define REMBLOCKS	0x28	; remaining blocks to load
#define REMTRACKS	0x29	; remaining tracks to load
#define REQDISK		0x2a	; disk pointer requested for operation
#define CURBYTE		0x2b	; the current loading byte in any block

#define TOP_LO		0x2c	; top of used memory (free memory)
#define TOP_HI		0x2d	; (high bits of above)

#define RUNSTATE	0x2e	; current running state, bits are
#define   RUNNING	0x00	; if no bits are set, then we're a runnin'
#define	  STOPPING	d'1'	; in the process of stopping
#define   STOPPED	d'2'	; stopped

#define WENABLE		0x2f	; bit 0 set if write is enabled

#define PCLATH_SAVE	0x30	; save for page register upon interrupt

SavePage	macro
                movf	PCLATH,W
                movwf	PCLATH_SAVE
                endm

RestorePage	macro
                movf	PCLATH_SAVE,W
                movwf	PCLATH
                endm

;;;
;;; The following only used in serbyte.asm
;;;

#define SBWORK		0x31

;;;
;;; The following only used in sertrack.asm
;;;

#define STWORK		0x32
#define SECCOUNT	0x33
#define STWORK2		0x3b

;;;
;;; The following only used in disk.asm
;;;
#define DSET0		0x34	; temp variable for DiskSetCopy()
#define DSET1		0x35	; temp variable for DiskSetCopy()
#define DSET2		0x36	; temp variable for DiskSetCopy()

;;;
;;; The following only used in serial.asm
;;;
#define SER0		0x37	; temp variable for serial functions
#define SER1		0x38	; temp variable for serial functions
#define SER2		0x39	; temp variable for serial functions
#define SER3		0x3a	; temp variable for serial functions

;#define STWORK2	0x3b	; see above in sertrack.asm variables

;;;
;;; Storage for the disk table
;;;
#define DTOFFSET	0x3c	; storage for disk table

;;;
;;; Used for sensing the break condition in interrupt
;;;
#define BREAKDETECT	0x3d

;;;
;;; Used for auto-increment of memory during trailers and blank secs.
;;;
#define INCVAR		0x3e

;;#define UNUSED		0x3f

;;;
;;; Apple GCR registers - used in apple.mac & apple.asm
;;;
#define GCR_OUT		0x40	; data is shifted from this register to RDATA
#define GCR_OUTREADY	0x41	; staging area for data to be placed in GCR_OUT
#define GCR_B1		0x42	; GCR mapping holding register  B1 <-- B2
#define GCR_B2		0x43	; GCR mapping staging register
#define GCR_B2CLEAR	0x44	; maintains the count of unused bits in B2
#define GCR_BYTECOUNT	0x45	; pre-GCR bytes remaining to be mapped and output

;;; -------------------------------------------------------------
;;; DISK DEFINITIONS
;;;	All of the routines in this code use the working set for
;;;	operations on a virtual disk.  When switching disks, the
;;;	register set is copied back and forth.  NOTE - the working
;;;	set is copied BACK into the disk when switching so that
;;;	its state is appropriately maintained.  I think this is
;;;	important for speed when doing disk copies.  Although it
;;;	isn't completely necessary IMHO.
;;;
;;;     NOTE - only the working set of disk params is in page 0.
;;;		Others are in page 1 and are only accessed via
;;;		indirect.
;;; -------------------------------------------------------------

;;; -------------------------
;;; CONSTANTS (not registers)
;;; -------------------------
#define DISKSETBYTES	0x0d	; number of bytes in a set (for copying)

;;; ---------------------------------------
;;; WORKING SET (accessible through bank 0)
;;; ---------------------------------------
#define ACTIVEDISK	0x60
#define HEADS		0x60	; number of heads (unused now)
#define TRACKS		0x61	; number of tracks
#define SECTORS		0x62	; number of sectors ()
#define BASE_LO		0x63	; low bits of disk block base (origin)
#define BASE_HI		0x64	; high bits of disk block base (origin)
#define CURBASE_LO	0x65	; current track base low bits
#define CURBASE_HI	0x66	; current track base hi bits
#define CURTRACK	0x67	; current track (used to check for origin)
#define	REMAINDER	0x68	; rem of unused blocks at end of 256 blocks
#define CURDISK		0x69	; the pointer to the currently active disk
                                ; this is NOT a number, it's DISK0 or DISK1
#define SECSIZE		0x6a	; size of sector (0=128, 1=256, 2=384, 3=512,...)
#define TRACKBLOCKS	0x6b	; number of blocks in a track
#define WRITEPROT	0x6c	; 0x01 if disk is write-protected, zero otherwise

;;; ------------------------------------------------------------
;;; TEMP COPY SET - in second mem page, accessed through index reg
;;; ------------------------------------------------------------
#define TEMPDISK	0xa0
;;#define HEADS		0xa0	; number of heads (unused now)
;;#define TRACKS	0xa1	; number of tracks
;;#define SECTORS	0xa2	; number of sectors ()
;;#define BASE_LO	0xa3	; low bits of disk block base (origin)
;;#define BASE_HI	0xa4	; high bits of disk block base (origin)
;;#define CURBASE_LO	0xa5	; current track base low bits
;;#define CURBASE_HI	0xa6	; current track base hi bits
;;#define CURTRACK	0xa7	; current track (used to check for origin)
;;#define REMAINDER	0xa8	; rem of unused blocks at end of 256 blocks
;;#define CURDISK	0xa9	; the pointer to this disk
                                ; this is NOT a number, it's DISK0 or DISK1
;;#define SECSIZE	0xaa	; size of sector (0=128, 1=256, 2=384, 3=512,...)
;;#define TRACKBLOCKS	0xab	; number of blocks in a track
;;#define WRITEPROT	0xac	; 0x01 if disk is write-protected, zero otherwise

;;; ------------------------------------------------------------
;;; DISK 0 - in second mem page, accessed through index reg
;;; ------------------------------------------------------------
#define DISK0		0xb0
;;#define HEADS		0xb0	; number of heads (unused now)
;;#define TRACKS	0xb1	; number of tracks
;;#define SECTORS	0xb2	; number of sectors ()
;;#define BASE_LO	0xb3	; low bits of disk block base (origin)
;;#define BASE_HI	0xb4	; high bits of disk block base (origin)
;;#define CURBASE_LO	0xb5	; current track base low bits
;;#define CURBASE_HI	0xb6	; current track base hi bits
;;#define CURTRACK	0xb7	; current track (used to check for origin)
;;#define REMAINDER	0xb8	; rem of unused blocks at end of 256 blocks
;;#define CURDISK	0xb9	; the pointer to this disk
                                ; this is NOT a number, it's DISK0 or DISK1
;;#define SECSIZE	0xba	; size of sector (0=128, 1=256, 2=384, 3=512,...)
;;#define TRACKBLOCKS	0xbb	; number of blocks in a track
;;#define WRITEPROT	0xbc	; 0x01 if disk is write-protected, zero otherwise
	
;;; ------------------------------------------------------------
;;; DISK 1 - in second mem page, accessed through index reg
;;; ------------------------------------------------------------
#define DISK1		0xc0
;;#define HEADS		0xc0	; number of heads (unused now)
;;#define TRACKS	0xc1	; number of tracks
;;#define SECTORS	0xc2	; number of sectors ()
;;#define BASE_LO	0xc3	; low bits of disk block base (origin)
;;#define BASE_HI	0xc4	; high bits of disk block base (origin)
;;#define CURBASE_LO	0xc5	; current track base low bits
;;#define CURBASE_HI	0xc6	; current track base hi bits
;;#define CURTRACK	0xc7	; current track (used to check for origin)
;;#define REMAINDER	0xc8	; rem of unused blocks at end of 256 blocks
;;#define CURDISK	0xc9	; the pointer to this disk
                                ; this is NOT a number, it's DISK0 or DISK1
;;#define SECSIZE	0xca	; size of sector (0=128, 1=256, 2=384, 3=512,...)
;;#define TRACKBLOCKS	0xcb	; number of blocks in a track
;;#define WRITEPROT	0xcc	; 0x01 if disk is write-protected, zero otherwise

;;; ------------------------------------------------------------
;;; DISK 2 - in second mem page, accessed through index reg
;;; ------------------------------------------------------------
#define DISK2		0xd0
;;#define HEADS		0xd0	; number of heads (unused now)
;;#define TRACKS	0xd1	; number of tracks
;;#define SECTORS	0xd2	; number of sectors ()
;;#define BASE_LO	0xd3	; low bits of disk block base (origin)
;;#define BASE_HI	0xd4	; high bits of disk block base (origin)
;;#define CURBASE_LO	0xd5	; current track base low bits
;;#define CURBASE_HI	0xd6	; current track base hi bits
;;#define CURTRACK	0xd7	; current track (used to check for origin)
;;#define REMAINDER	0xd8	; rem of unused blocks at end of 256 blocks
;;#define CURDISK	0xd9	; the pointer to this disk (0 = 1 block per sector)
                                ; this is NOT a number, it's DISK0 or DISK1
;;#define SECSIZE	0xda	; size of sector (0=128, 1=256, 2=384, 3=512,...)
;;#define TRACKBLOCKS	0xdb	; number of blocks in a track
;;#define WRITEPROT	0xdc	; 0x01 if disk is write-protected, zero otherwise

;;; ---------------
;;; DISK 3
;;; ---------------
#define DISK3	DISK1

;;; ---------------------------------------
;;; NULL DISK - used as a "null" disk value
;;; ---------------------------------------
#define NULLDISK	TEMPDISK

;;; =======================================================================
;;; =======================================================================
